Attribute VB_Name = "modCCSQL_CreateEnums"
Option Compare Database
Option Explicit

Public Sub CreateEnumModule()
    Dim strPathAndFile As String
    Dim f As Integer
    Dim db As DAO.Database
    Dim td As DAO.TableDef
    Dim qd As DAO.QueryDef
    Dim fld As DAO.Field
    Dim strOut As String
    Dim strFunction As String
    Dim strField As String
    Dim strField2 As String
    Dim strTable As String
    
    f = FreeFile
    strPathAndFile = CurrentProject.Path & "\modCCSQL_TableEnums.bas"
    Open strPathAndFile For Output As #f
    
    strOut = "' ######################################################################################" & vbCr & _
                "' --------------------------------------------------------------------------------------" & vbCr & _
                "' --------- This module is automatically generated with ""CreateEnumModule"" -------------" & vbCr & _
                "' --------- To refresh, call this procedure again and reimport this module -------------" & vbCr & _
                "' --------------------------------------------------------------------------------------" & vbCr & _
                "' ######################################################################################" & vbCr & vbCr
    Print #f, strOut
    
    ' --------------------------------------------
    ' Create header, table and query enums
    ' --------------------------------------------
    strOut = "Attribute VB_Name = ""modCCSQL_TableEnums""" & vbCr & _
                "Option Compare Database" & vbCr & _
                "Option Explicit" & vbCr & vbCr & _
                "' Set this to False if the functions should not raise an error but return an empty string instead" & vbCr & _
                "Private Const cRaiseError As Boolean = True" & vbCr & vbCr & _
                "Private prv_objCCSQL As clsCCSQL" & vbCr & vbCr & GetTableEnum() & vbCr & vbCr & GetQueryEnum() & vbCr & vbCr
    Print #f, strOut
    
    Set db = CurrentDb
    ' --------------------------------------------
    ' Create field enums for tables
    ' --------------------------------------------
    For Each td In db.TableDefs
        If (td.Attributes And dbSystemObject) = 0 And (td.Attributes And dbHiddenObject) = 0 Then
            strOut = "Public Enum Tab_" & Replace(td.Name, " ", "_") & vbCr
            For Each fld In td.Fields
                strOut = strOut & "    enm_" & Replace(fld.Name, " ", "_") & vbCr
            Next
            strOut = strOut & "    [_enm_Count]" & vbCr
            strOut = strOut & "End Enum" & vbCr
            Print #f, strOut
        End If
    Next
    
    ' --------------------------------------------
    ' Create field enums for queries
    ' --------------------------------------------
    For Each qd In db.QueryDefs
        If (qd.Type = dbQSelect Or qd.Type = dbQSetOperation) And Left(qd.Name, 1) <> "~" Then
            strOut = "Public Enum Qry_" & Replace(qd.Name, " ", "_") & vbCr
            For Each fld In qd.Fields
                strOut = strOut & "    enmQ_" & Replace(Replace(fld.Name, " ", "_"), ".", "_") & vbCr
            Next
            strOut = strOut & "    [_enm_Count]" & vbCr
            strOut = strOut & "End Enum" & vbCr
            Print #f, strOut
        End If
    Next
    
    ' --------------------------------------------
    ' Create "CCSQL" function for class clsCCSQL
    ' --------------------------------------------
    strOut = "Public Function CCSQL() As clsCCSQL" & vbCr & _
                "    If prv_objCCSQL Is Nothing Then Set prv_objCCSQL = New clsCCSQL" & vbCr & _
                "    Set CCSQL = prv_objCCSQL" & vbCr & _
                "End Function" & vbCr
    
    Print #f, strOut
    
        
    ' ---------------------------------------------------------------------------
    ' Create "Tab_Name" function (returns the name of a table in square brackets)
    ' ---------------------------------------------------------------------------
    strFunction = "Tab_Name"
    strOut = "Public Function " & strFunction & "(intTable As EnmMyTables) As String" & vbCr
    strOut = strOut & "    Select Case intTable" & vbCr
    For Each td In db.TableDefs
        If (td.Attributes And dbSystemObject) = 0 And (td.Attributes And dbHiddenObject) = 0 Then
            strTable = Replace(td.Name, " ", "_")
            strOut = strOut & "        Case EnmMyTables.enmMyTables_" & strTable & _
                           ": " & strFunction & "= ""[" & strTable & "]""" & vbCr
        End If
    Next
    strOut = strOut & "        Case Else" & vbCr & _
                            "            If not cRaiseError Then" & vbCr & _
                            "                " & strFunction & "= """"" & vbCr & _
                            "            Else" & vbCr & _
                            "                Err.Raise vbObjectError + 1, """ & strFunction & """, ""Specified table value does not exist in the enumeration """"EnmMyTables""""." & vbCr & _
                            "            End If" & vbCr
    strOut = strOut & "    End Select" & vbCr & _
                            "End Function" & vbCr
    
    strOut = strOut & vbCr & _
                "Public Function Tab_Names_All() As String" & vbCr & _
                "    Dim strTables As String" & vbCr & _
                "    Dim i As Long" & vbCr & vbCr & _
                "    For i = 0 To EnmMyTables.[_enm_Count] - 1" & vbCr & _
                "        strTables = strTables & Tab_Name(i) & "",""" & vbCr & _
                "    Next" & vbCr & _
                "    If Len(strTables) >= 1 Then strTables = Left(strTables, Len(strTables) - 1)" & vbCr & _
                "    Tab_Names_All = strTables" & vbCr & _
                "End Function" & vbCr & vbCr
    
    Print #f, strOut
    
    ' ---------------------------------------------------------------------------
    ' Create "Qry_Name" function (returns the name of a query in square brackets)
    ' ---------------------------------------------------------------------------
    strFunction = "Qry_Name"
    strOut = "Public Function " & strFunction & "(intQuery As EnmMyQueries) As String" & vbCr
    strOut = strOut & "    Select Case intQuery" & vbCr
    For Each qd In db.QueryDefs
        If (qd.Type = dbQSelect Or qd.Type = dbQSetOperation) And Left(qd.Name, 1) <> "~" Then
            strTable = Replace(qd.Name, " ", "_")
            strOut = strOut & "        Case EnmMyQueries.enmMyQueries_" & strTable & _
                           ": " & strFunction & "= ""[" & strTable & "]""" & vbCr
        End If
    Next
    strOut = strOut & "        Case Else" & vbCr & _
                            "            If not cRaiseError Then" & vbCr & _
                            "                " & strFunction & "= """"" & vbCr & _
                            "            Else" & vbCr & _
                            "                Err.Raise vbObjectError + 1, """ & strFunction & """, ""Specified query value does not exist in the enumeration """"EnmMyQueries""""." & vbCr & _
                            "            End If" & vbCr
    strOut = strOut & "    End Select" & vbCr & _
                            "End Function" & vbCr
    strOut = strOut & vbCr & _
                "Public Function Qry_Names_All() As String" & vbCr & _
                "    Dim strQueries As String" & vbCr & _
                "    Dim i As Long" & vbCr & vbCr & _
                "    For i = 0 To EnmMyQueries.[_enm_Count] - 1" & vbCr & _
                "        strQueries = strQueries & Qry_Name(i) & "",""" & vbCr & _
                "    Next" & vbCr & _
                "    If Len(strQueries) >= 1 Then strQueries = Left(strQueries, Len(strQueries) - 1)" & vbCr & _
                "    Qry_Names_All = strQueries" & vbCr & _
                "End Function" & vbCr & vbCr
    Print #f, strOut
    
                
    ' -----------------------------------------------------------------------------------------------------------
    ' Create "Field_Names_All" and "QField_Names_All" functions for tables and queries (returns all column names)
    ' -----------------------------------------------------------------------------------------------------------
    strOut = vbCr & _
                "Public Function Field_Names_All(intTable As EnmMyTables) As String" & vbCr & _
                "    Select Case intTable" & vbCr
    For Each td In db.TableDefs
        If (td.Attributes And dbSystemObject) = 0 And (td.Attributes And dbHiddenObject) = 0 Then
            strTable = Replace(td.Name, " ", "_")
            strOut = strOut & "        Case EnmMyTables.enmMyTables_" & strTable & _
                                    ": Field_Names_All = Fld_" & strTable & "_All()" & vbCr
        End If
    Next
    strOut = strOut & _
                "        Case Else" & vbCr & _
                "            If Not cRaiseError Then" & vbCr & _
                "                Field_Names_All = """"" & vbCr & _
                "            Else" & vbCr & _
                "                Err.Raise vbObjectError + 1, ""Field_Names_All"", ""Specified table value does not exist in the enumeration """"EnmMyTables"""".""" & vbCr & _
                "            End If" & vbCr & _
                "    End Select" & vbCr & _
                "End Function" & vbCr
    Print #f, strOut

    strOut = vbCr & vbCr & _
                "Public Function QField_Names_All(intQuery As EnmMyQueries) As String" & vbCr & _
                "    Select Case intQuery" & vbCr
    For Each qd In db.QueryDefs
        If (qd.Type = dbQSelect Or qd.Type = dbQSetOperation) And Left(qd.Name, 1) <> "~" Then
            strTable = Replace(qd.Name, " ", "_")
            strOut = strOut & "        Case EnmMyQueries.enmMyQueries_" & strTable & _
                                    ": QField_Names_All = QFld_" & strTable & "_All()" & vbCr
        End If
    Next
    strOut = strOut & _
                "        Case Else" & vbCr & _
                "            If Not cRaiseError Then" & vbCr & _
                "                QField_Names_All = """"" & vbCr & _
                "            Else" & vbCr & _
                "                Err.Raise vbObjectError + 1, ""QField_Names_All"", ""Specified query value does not exist in the enumeration """"EnmMyQueries"""".""" & vbCr & _
                "            End If" & vbCr & _
                "    End Select" & vbCr & _
                "End Function" & vbCr
    Print #f, strOut
    
    ' -------------------------------------------------------------------------------------------------
    ' Create "Fld_xxx" and "Fld_xxx_All" functions for tables (returns single or multiple column names)
    ' -------------------------------------------------------------------------------------------------
    For Each td In db.TableDefs
        If (td.Attributes And dbSystemObject) = 0 And (td.Attributes And dbHiddenObject) = 0 Then
            strTable = Replace(td.Name, " ", "_")
            strFunction = "Fld_" & strTable
            strOut = "Public Function " & strFunction & _
                           "(intField As Tab_" & strTable & ") As String" & vbCr
            strOut = strOut & "    Select Case intField" & vbCr
            For Each fld In td.Fields
                strField = Replace(fld.Name, " ", "_")
                strOut = strOut & "        Case Tab_" & strTable & ".enm_" & strField & _
                                        ": " & strFunction & "= ""[" & fld.Name & "]""" & vbCr
            Next
            strOut = strOut & "        Case Else" & vbCr & _
                                    "            If not cRaiseError Then" & vbCr & _
                                    "                " & strFunction & "= """"" & vbCr & _
                                    "            Else" & vbCr & _
                                    "                Err.Raise vbObjectError + 1, """ & strFunction & """, ""Specified field value does not exist in the enumeration """"Tab_" & strTable & """""." & vbCr & _
                                    "            End If" & vbCr
            strOut = strOut & "    End Select" & vbCr & "End Function" & vbCr
            Print #f, strOut
        
            strOut = "Public Function Fld_" & strTable & "_All(ParamArray intWithoutField() As Variant) As String" & vbCr & _
                        "    Dim varField As Variant" & vbCr & _
                        "    Dim strError As String" & vbCr & _
                        "    Dim strFields As String" & vbCr & _
                        "    Dim i As Long" & vbCr & vbCr & _
                        "    For Each varField In intWithoutField" & vbCr & _
                        "        If VarType(varField) <> vbInteger And VarType(varField) <> vbLong Then" & vbCr & _
                        "            strError = ""Please choose from Enum Tab_" & strTable & " only.""" & vbCr & _
                        "        ElseIf varField > Tab_" & strTable & ".[_enm_Count] - 1 Then" & vbCr & _
                        "             strError = ""The specified field number does not exist in the Enum Tab_" & strTable & "." & vbCr & _
                        "        End If" & vbCr & _
                        "    Next" & vbCr
            strOut = strOut & vbCr & _
                        "    If strError <> """" Then" & vbCr & _
                        "        If cRaiseError Then Err.Raise vbObjectError + 1, ""Fld_" & strTable & "_All"", strError" & vbCr & _
                        "    Else" & vbCr & _
                        "        For i = 0 To Tab_" & strTable & ".[_enm_Count] - 1" & vbCr & _
                        "            strFields = strFields & Fld_" & strTable & "(i) & "",""" & vbCr & _
                        "        Next" & vbCr & _
                        "        If Len(strFields) >= 1 Then strFields = Left(strFields, Len(strFields) - 1)" & vbCr & vbCr & _
                        "        For Each varField In intWithoutField" & vbCr & _
                        "            strFields = Replace(strFields, Fld_" & strTable & "(CInt(varField)), """")" & vbCr & _
                        "        Next" & vbCr & _
                        "        Do" & vbCr & _
                        "            strFields = Replace(strFields, "",,"", "","")" & vbCr & _
                        "        Loop Until InStr(strFields, "",,"") = 0" & vbCr & _
                        "    End If" & vbCr
            strOut = strOut & _
                        "    If Left(strFields, 1) = "","" Then strFields = Right(strFields, Len(strFields) - 1)" & vbCr & _
                        "    If Right(strFields, 1) = "","" Then strFields = Left(strFields, Len(strFields) - 1)" & vbCr & vbCr & _
                        "    " & strFunction & "_All = strFields" & vbCr & _
                        "End Function" & vbCr
            Print #f, strOut
        End If
    Next
    
    ' ----------------------------------------------------------------------------------------------------
    ' Create "QFld_xxx" and "QFld_xxx_All" functions for queries (returns single or multiple column names)
    ' ----------------------------------------------------------------------------------------------------
    For Each qd In db.QueryDefs
        If (qd.Type = dbQSelect Or qd.Type = dbQSetOperation) And Left(qd.Name, 1) <> "~" Then
            strTable = Replace(qd.Name, " ", "_")
            strFunction = "QFld_" & strTable
            strOut = "Public Function " & strFunction & _
                           "(intQryField As Qry_" & strTable & ") As String" & vbCr
            strOut = strOut & "    Select Case intQryField" & vbCr
            For Each fld In qd.Fields
                strField = Replace(Replace(fld.Name, " ", "_"), ".", "_")
                strField2 = Replace(fld.Name, ".", "].[")
                strOut = strOut & "        Case Qry_" & strTable & ".enmQ_" & strField & _
                                        ": " & strFunction & "= ""[" & strField2 & "]""" & vbCr
            Next
            strOut = strOut & "        Case Else" & vbCr & _
                                    "            If not cRaiseError Then" & vbCr & _
                                    "                " & strFunction & "= """"" & vbCr & _
                                    "            Else" & vbCr & _
                                    "                Err.Raise vbObjectError + 1, """ & strFunction & """, ""Specified field value does not exist in the enumeration """"Qry_" & strTable & """""." & vbCr & _
                                    "            End If" & vbCr
            strOut = strOut & "    End Select" & vbCr & "End Function" & vbCr
            Print #f, strOut
        
            strOut = "Public Function QFld_" & strTable & "_All(ParamArray intWithoutQryField() As Variant) As String" & vbCr & _
                        "    Dim varField As Variant" & vbCr & _
                        "    Dim strError As String" & vbCr & _
                        "    Dim strFields As String" & vbCr & _
                        "    Dim i As Long" & vbCr & vbCr & _
                        "    For Each varField In intWithoutQryField" & vbCr & _
                        "        If VarType(varField) <> vbInteger And VarType(varField) <> vbLong Then" & vbCr & _
                        "            strError = ""Please choose from Enum Qry_" & strTable & " only.""" & vbCr & _
                        "        ElseIf varField > Qry_" & strTable & ".[_enm_Count] - 1 Then" & vbCr & _
                        "             strError = ""The specified field number does not exist in the Enum Qry_" & strTable & "." & vbCr & _
                        "        End If" & vbCr & _
                        "    Next" & vbCr
            strOut = strOut & vbCr & _
                        "    If strError <> """" Then" & vbCr & _
                        "        If cRaiseError Then Err.Raise vbObjectError + 1, ""QFld_" & strTable & "_All"", strError" & vbCr & _
                        "    Else" & vbCr & _
                        "        For i = 0 To Qry_" & strTable & ".[_enm_Count] - 1" & vbCr & _
                        "            strFields = strFields & QFld_" & strTable & "(i) & "",""" & vbCr & _
                        "        Next" & vbCr & _
                        "        If Len(strFields) >= 1 Then strFields = Left(strFields, Len(strFields) - 1)" & vbCr & vbCr & _
                        "        For Each varField In intWithoutQryField" & vbCr & _
                        "            strFields = Replace(strFields, QFld_" & strTable & "(CInt(varField)), """")" & vbCr & _
                        "        Next" & vbCr & _
                        "        Do" & vbCr & _
                        "            strFields = Replace(strFields, "",,"", "","")" & vbCr & _
                        "        Loop Until InStr(strFields, "",,"") = 0" & vbCr & _
                        "    End If" & vbCr
            strOut = strOut & _
                        "    If Left(strFields, 1) = "","" Then strFields = Right(strFields, Len(strFields) - 1)" & vbCr & _
                        "    If Right(strFields, 1) = "","" Then strFields = Left(strFields, Len(strFields) - 1)" & vbCr & vbCr & _
                        "    " & strFunction & "_All = strFields" & vbCr & _
                        "End Function" & vbCr
            Print #f, strOut
        End If
    Next
    
    strOut = vbCr & "Public Function ConvertToParamArray(strArray() As String) As Variant()" & vbCr & _
             "    Dim varArray() As Variant" & vbCr & _
             "    Dim i As Long" & vbCr & vbCr & _
             "    ReDim varArray(UBound(strArray))" & vbCr & _
             "    For i = LBound(strArray) To UBound(strArray)" & vbCr & _
             "        varArray(i) = CVar(strArray(i))" & vbCr & _
             "    Next" & vbCr & _
             "    ConvertToParamArray = varArray" & vbCr & _
             "End Function" & vbCr
    Print #f, strOut
    
    Close #f
    Set fld = Nothing
    Set td = Nothing
    Set db = Nothing
    MsgBox "Completed! Please delete the module ""modCCSQL_TableEnums"" and reimport it from the path of your current database now!"
End Sub

Private Function GetTableEnum() As String
    Dim db As DAO.Database
    Dim td As DAO.TableDef
    Dim strOut As String
    
    Set db = CurrentDb
    
    strOut = "Public Enum EnmMyTables" & vbCr
    For Each td In db.TableDefs
        If (td.Attributes And dbSystemObject) = 0 And (td.Attributes And dbHiddenObject) = 0 Then
            strOut = strOut & "    enmMyTables_" & Replace(td.Name, " ", "_") & vbCr
        End If
    Next
    strOut = strOut & "    [_enm_Count]" & vbCr & "End Enum"
    Set td = Nothing
    Set db = Nothing
    GetTableEnum = strOut
End Function

Private Function GetQueryEnum() As String
    Dim db As DAO.Database
    Dim qd As DAO.QueryDef
    Dim strOut As String

    Set db = CurrentDb
    
    strOut = "Public Enum EnmMyQueries" & vbCr
    For Each qd In db.QueryDefs
        If (qd.Type = dbQSelect Or qd.Type = dbQSetOperation) And Left(qd.Name, 1) <> "~" Then
            strOut = strOut & "    enmMyQueries_" & Replace(qd.Name, " ", "_") & vbCr
        End If
    Next
    strOut = strOut & "    [_enm_Count]" & vbCr & "End Enum"
    Set qd = Nothing
    Set db = Nothing
    GetQueryEnum = strOut
End Function
