VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsCCTimerMessage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Compare Database
Option Explicit

'---------------------------------------------------------------------------------------
' Module      : clsCCTimerMessage
' Version     : 1.0
' Author      : Christian Coppes
' Date        : 09.08.2012
' Last Change : 09.08.2012
' Purpose     : Displays a message in a textbox which will be removed with timer
'---------------------------------------------------------------------------------------

' ######################################################################################
' --------------------------------------------------------------------------------------
' -------------------------------------- Constants -------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private Const cMODULENAME As String = "clsCCTimerMessage"
Private Const cEVENTPROC As String = "[Event Procedure]"

' ######################################################################################
' --------------------------------------------------------------------------------------
' ----------------------------------- Class Variables ----------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private WithEvents prv_frmMsg As Access.Form
Attribute prv_frmMsg.VB_VarHelpID = -1
Private prv_txtMsg As Access.TextBox

' ######################################################################################
' --------------------------------------------------------------------------------------
' ------------------------------------- Properties -------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Public TimeToDisplay    As Long
Public MakeInvisible    As Boolean

' ######################################################################################
' --------------------------------------------------------------------------------------
' -------------------------------------- Methods ---------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

'---------------------------------------------------------------------------------------
' Procedure   : InitMessage
' Date        : 09.08.2012
' Last Change : 09.08.2012
' Purpose     : Initialization of message class
' Parameters  : frm: Form which contains the message textbox
'               txt: Textbox to display the message
'               lngDefaultTimeToDisplay: Default time for message to be displayed, if not
'                                        specified, the default value of Class_Initialize is used
'               bolMakeInvisible: If set to true then the message box will be made visible
'                                 before the message is displayed and made invisible after time elapsed
'                                 (Useful if textbox has an invisible background and overlaps
'                                 other controls)
' Returns     :  -
'---------------------------------------------------------------------------------------
'
Public Sub InitMessage(frm As Access.Form, txt As Access.TextBox, _
                       Optional lngDefaultTimeToDisplay As Long = 0, _
                       Optional bolMakeInvisible As Boolean = False)
    If Not (frm Is Nothing Or txt Is Nothing) Then
        Set prv_frmMsg = frm
        With prv_frmMsg
            .OnTimer = cEVENTPROC
            .TimerInterval = 0
        End With
        
        Set prv_txtMsg = txt
        
        If lngDefaultTimeToDisplay > 0 Then Me.TimeToDisplay = lngDefaultTimeToDisplay
        Me.MakeInvisible = bolMakeInvisible
    End If
End Sub

'---------------------------------------------------------------------------------------
' Procedure   : DisplayMsg
' Date        : 09.08.2012
' Last Change : 09.08.2012
' Purpose     : Displays the message for the defined time (microseconds) in the message textbox
' Parameters  : strText: Text to be displayed
'               lngTimeToDisaply: Optional time in microseconds, if not defined, default
'                                 of 4000 microseconds is used
' Returns     :  -
'---------------------------------------------------------------------------------------
'
Public Sub DisplayMsg(strText As String, Optional lngTimeToDisplay As Long = 0)
    If Not (prv_frmMsg Is Nothing Or prv_txtMsg Is Nothing) Then
        If Me.MakeInvisible Then prv_txtMsg.Visible = True
        prv_txtMsg.Value = strText
        If lngTimeToDisplay = 0 Then
            prv_frmMsg.TimerInterval = Me.TimeToDisplay
        Else
            prv_frmMsg.TimerInterval = lngTimeToDisplay
        End If
    End If
End Sub

' ######################################################################################
' --------------------------------------------------------------------------------------
' ---------------------------------- Event Procedures ----------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private Sub prv_frmMsg_Timer()
    If Not prv_txtMsg Is Nothing Then
        prv_txtMsg = Null
        If Me.MakeInvisible Then prv_txtMsg.Visible = False
    End If
    prv_frmMsg.TimerInterval = 0
End Sub


' ######################################################################################
' --------------------------------------------------------------------------------------
' ------------------------------ Constructor / Destructor ------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private Sub Class_Initialize()
    Me.TimeToDisplay = 4000     ' Default time to display a message
    Me.MakeInvisible = False
End Sub

Private Sub Class_Terminate()
    Set prv_frmMsg = Nothing
    Set prv_txtMsg = Nothing
End Sub